<?php

/**
 *
 * Site Setup
 *
 */

function focus_setup()
{
    // Register navigation menus.
    register_nav_menus(
        array(
            'header' => esc_html__('Header Menu', 'focus'),
            'footer' => esc_html__('Footer Menu', 'focus'),
            'footer_services' => esc_html__('Footer Services Menu', 'focus'),
            'legal' => esc_html__('Legal Menu', 'focus')
        )
    );

    add_theme_support( 'post-thumbnails' );

    // Image Crops
    add_image_size('news-listing', 562, 294, true);
    add_image_size('content-image', 795, 569, true);
    add_image_size('team-member', 700, 800, true);
    add_image_size('project-listing', 770, 602, true);
}

add_action('after_setup_theme', 'focus_setup');


/**
 *
 * Stylesheets and Scripts
 *
 */

function add_theme_scripts() {
    $map_api_key = get_theme_mod('map_api_key');

    // Styles
    wp_enqueue_style( 'bootstrap', get_stylesheet_directory_uri() . '/assets/css/bootstrap.css', array(), '1');
    wp_enqueue_style( 'slick', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1');
    wp_enqueue_style( 'styles', get_stylesheet_directory_uri() . '/assets/css/style.css', array(), '1.1');

    // Scripts
    wp_enqueue_script( 'jquery', 'https://code.jquery.com/jquery-3.5.1.min.js', array ( 'jquery' ), '3.5.1', true);
    wp_enqueue_script( 'popper', 'https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js', array ( 'jquery' ), '1.12.9', true);
    wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/vendor/bootstrap.min.js', array ( 'jquery' ), '4.5.3', true);
    wp_enqueue_script( 'slick', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array ( 'jquery' ), '1.8.1', true);
    wp_enqueue_script( 'maps', 'https://maps.googleapis.com/maps/api/js?key=' . $map_api_key, array ( 'jquery' ), '1', true);
    wp_enqueue_script( 'scrolltofixed', get_stylesheet_directory_uri() . '/assets/js/vendor/scrolltofixed.js', array ( 'jquery' ), '1', true);
    wp_enqueue_script( 'custom', get_stylesheet_directory_uri() . '/assets/js/custom.js', array ( 'jquery' ), '1', true);
    wp_enqueue_script( 'fontawesome', 'https://kit.fontawesome.com/41fa0ea811.js', null, '5', true);
}

add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );


/**
 *
 * ACF JSON Set up
 *
 */

require_once(get_template_directory() . '/inc/acf/config.php');


/**
 *
 * Register Custom Post Types
 *
 */
require_once(get_template_directory() . '/inc/post-types/service.php');
require_once(get_template_directory() . '/inc/post-types/sector.php');
require_once(get_template_directory() . '/inc/post-types/project.php');
require_once(get_template_directory() . '/inc/post-types/career.php');
require_once(get_template_directory() . '/inc/post-types/team-member.php');


/**
 *
 * Register Custom Taxonomies
 *
 */
//require_once(get_template_directory() . '/inc/taxonomies/member-type.php');

/**
 *
 * Register Customizer Fields
 *
 */
require_once(get_template_directory() . '/inc/customizer.php');


/**
 *
 * ACF Option Pages
 *
 */
if( function_exists('acf_add_options_page') ) {
    acf_add_options_page(array(
        'page_title' 	=> 'Theme Settings',
        'menu_title'	=> 'Theme Settings',
        'menu_slug' 	=> 'theme-general-settings',
        'capability'	=> 'edit_posts',
        'redirect'		=> true
    ));

    acf_add_options_sub_page(array(
        'page_title' 	=> 'Featured Footer',
        'menu_title'	=> 'Featured Footer',
        'parent_slug'	=> 'theme-general-settings',
    ));

    acf_add_options_sub_page(array(
        'page_title' 	=> 'Accreditation Logos',
        'menu_title'	=> 'Accreditation Logos',
        'parent_slug'	=> 'theme-general-settings',
    ));
}


/**
 *
 * Allow SVG Media Upload
 *
 */
function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');


/**
*
* Format Buttons from ACF Link fields
*
 */
function format_button($link, $additional_classes = "btn-primary", $arrow = false) {
    $url = $link['url'];
    $title = $link['title'];
    $target = $link['target'];
    $classes = "btn " . $additional_classes;
    $text = $title;

    if($arrow == true) {
        $text .= '<span class="btn__arrow"><i class="far fa-arrow-right"></i></span>';
    }

    return '<a href="'.$url.'" title="'.$title.'" target="'.$target.'" class="'.$classes.'">'.$text.'</a>';
}


/**
 *
 * Get blog posts page URL.
 *
 */
function get_news_page_url()
{

    if ('page' === get_option('show_on_front')) {
        return get_permalink(get_option('page_for_posts'));
    }

    return get_home_url();
}


/**
 *
 * Get listing page id
 *
 */
function get_listing_page_id($post_type)
{
    $listing_page_id = get_theme_mod($post_type . '_listing_page_id');
    if($listing_page_id != null) {
        return $listing_page_id;
    }

    return null;
}


/**
 *
 * Get listing page URL.
 *
 */
function get_listing_page_url($post_type)
{
    $listing_page_id = get_listing_page_id($post_type);
    if($listing_page_id != null) {
        return get_the_permalink($listing_page_id);
    }

    return get_home_url();
}


/**
 *
 * Custom Pagination
 *
 */

function focus_custom_pagination($max_pages, $base_url, $page = 1, $ajax_pagination = false) {
    $pagination = "";
    if($max_pages > 1) {
        $pagination .= "<ul class='pagination d-flex justify-content-center align-items-center'>";

        // Previous Arrow
        if($page > 1) {
            $classes = "pagination__link pagination__arrow-link";
            if($ajax_pagination == true) {
                $classes .= " js-pagination-link";
            }

            $pagination .= "<li class='pagination__item'>";
            $pagination .= "<a href='" . get_pagenum_link(($page - 1)) . "' class='" . $classes . "' data-page-no='". ($page - 1) ."'>";
            $pagination .= '<svg aria-hidden="true" focusable="false" data-prefix="fas" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M34.52 239.03L228.87 44.69c9.37-9.37 24.57-9.37 33.94 0l22.67 22.67c9.36 9.36 9.37 24.52.04 33.9L131.49 256l154.02 154.75c9.34 9.38 9.32 24.54-.04 33.9l-22.67 22.67c-9.37 9.37-24.57 9.37-33.94 0L34.52 272.97c-9.37-9.37-9.37-24.57 0-33.94z"></path></svg>';
            $pagination .= "</a>";
            $pagination .= "</li>";
        }

        for ($i = 1; $i <= $max_pages; $i++) {
            $pagination .= "<li class='pagination__item'>";

            if($i == $page) {
                $pagination .= "<span class='pagination__current'>" . $i . "</span>";
            } else {
                $classes = "pagination__link";
                if($ajax_pagination == true) {
                    $classes .= " js-pagination-link";
                }

                $pagination .= "<a href='" . get_pagenum_link($i) . "' class='" . $classes . "' data-page-no='". $i ."'>";
                $pagination .= $i . "</a>";
            }

            $pagination .= "</li>";
        }

        // Next Arrow
        if($page < $max_pages) {
            $classes = "pagination__link pagination__arrow-link";
            if($ajax_pagination == true) {
                $classes .= " js-pagination-link";
            }

            $pagination .= "<li class='pagination__item'>";
            $pagination .= "<a href='" . get_pagenum_link($page + 1) . "' class='" . $classes . "' data-page-no='". ($page + 1) ."'>";
            $pagination .= '<svg aria-hidden="true" focusable="false" data-prefix="fas" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"></path></svg>';
            $pagination .= "</a>";
            $pagination .= "</li>";
        }

        $pagination .= "</ul>";
    }

    return $pagination;
}


/**
 *
 * Prepare Video Embed Scripts
 *
 */
function prepare_video_embed($url, $parameters = null) {
    $embed_script = "";
    $embed_url = "";

    if (strpos($url, 'vimeo') !== false) {
        // Vimeo
        $explosion = array_filter(explode('/', $url));
        $id = end($explosion);
        $embed_url = "https://player.vimeo.com/video/" . $id;
    } elseif (strpos($url, 'youtube') !== false || strpos($url, 'youtu.be') !== false) {
        // YouTube
        $explode_by = ['v=', '/', 'embed'];
        $explosion = null;

        foreach($explode_by as $type) {
            if(mb_strpos($url, $type)) {
                $explosion = explode($type, $url);
                break;
            }
        }

        if($explosion != null && !empty($explosion)) {
            $explosion = array_filter($explosion);
        }

        $id = end($explosion);
        $embed_url = "https://www.youtube.com/embed/" . $id;
    }

    if($embed_url != '') {
        if($parameters != null) {
            $embed_url .= "?";

            $count = 1;
            foreach ($parameters as $param) {
                $embed_url .= $param;

                if($count < count($parameters)) {
                    $embed_url .= '&';
                }

                $count++;
            }
        }

        $embed_script = '<iframe src="'.$embed_url.'" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>';
    }

    return $embed_script;
}


/**
 *
 * Build Menu Array
 *
 */
function wp_get_menu_array($current_menu) {
    $menu_array = wp_get_nav_menu_items($current_menu);
    $menu = array();

    function populate_children($menu_array, $menu_item)
    {
        $children = array();
        if (!empty($menu_array)){
            foreach ($menu_array as $k=>$m) {
                if ($m->menu_item_parent == $menu_item->ID) {
                    $children[$m->ID] = array();
                    $children[$m->ID]['ID'] = $m->ID;
                    $children[$m->ID]['title'] = $m->title;
                    $children[$m->ID]['url'] = $m->url;
                    unset($menu_array[$k]);
                    $children[$m->ID]['children'] = populate_children($menu_array, $m);
                }
            }
        };
        return $children;
    }

    foreach ($menu_array as $m) {
        if (empty($m->menu_item_parent)) {
            $menu[$m->ID] = array();
            $menu[$m->ID]['ID'] = $m->ID;
            $menu[$m->ID]['title'] = $m->title;
            $menu[$m->ID]['url'] = $m->url;
            $menu[$m->ID]['children'] = populate_children($menu_array, $m);
        }
    }

    return $menu;
}


/**
 *
 * Render Masthead
 *
 */
function render_masthead($prefix = '', $args = array()) {
    $defaults = array(
        'masthead_background_image' => get_field($prefix . '_masthead_background_image'),
        'masthead_title' => get_field($prefix . '_masthead_title'),
        'masthead_subtitle' => get_field($prefix . '_masthead_subtitle'),
        'masthead_content' => get_field($prefix . '_masthead_content'),
        'masthead_button' => get_field($prefix . '_masthead_button'),
        'masthead_size' => get_field($prefix . '_masthead_size'),
        'show_breadcrumb' => false,
        'show_overlay' => true
    );

    $data = array_merge($defaults, $args);

    if($data['masthead_title'] == '') {
        $data['masthead_title'] = get_the_title();
    }

    include(get_template_directory() . '/inc/blocks/masthead.php');
    unset($data);
}


/**
 *
 * Render Content Blocks
 *
 */
function render_content_blocks($prefix = '') {
    $content_blocks = get_field($prefix . '_content_blocks');

    include(get_template_directory() . '/inc/blocks/content-blocks.php');
    unset($content_blocks);
}


/**
 *
 * Remove Comments from Admin Nav
 *
 */
add_action( 'admin_menu', 'my_remove_admin_menus' );
function my_remove_admin_menus() {
    remove_menu_page( 'edit-comments.php' );
}


/**
 *
 * Add URL parameters for Filtering
 *
 */
add_action('init','add_get_val');
function add_get_val() {
    global $wp;
    $wp->add_query_var('services');
    $wp->add_query_var('sectors');
}