<?php if (isset($content_blocks) && !empty($content_blocks)) {
    foreach ($content_blocks as $block) {
        if ($block['acf_fc_layout'] == 'text_block') { ?>
            <section class="content-block">
                <div class="text-block">
                    <?php echo $block['content']; ?>
                </div>
            </section>
        <?php } elseif ($block['acf_fc_layout'] == 'two_column_text_block') { ?>
            <section class="content-block content-block__two-col">
                <div class="row">
                    <div class="col-12 col-lg-6">
                        <?php if ($block['left_title'] != '') { ?>
                            <h4 class="mt-0 content-block__two-col__title">
                                <?php echo $block['left_title']; ?></h4>
                        <?php } ?>

                        <div class="text-block">
                            <?php echo $block['left_content']; ?>
                        </div>
                    </div>

                    <div class="col-12 col-lg-6">
                        <?php if ($block['right_title'] != '') { ?>
                            <h4 class="mt-0 content-block__two-col__title">
                                <?php echo $block['right_title']; ?></h4>
                        <?php } ?>

                        <div class="text-block">
                            <?php echo $block['right_content']; ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php } elseif ($block['acf_fc_layout'] == 'image_block') { ?>
            <section class="content-block content-block__image">
                <?php if ($block['image'] != null) { ?>
                    <img src="<?php echo $block['image']['url']; ?>"
                         alt="<?php echo $block['image']['alt']; ?>"
                         class="img-fluid"/>
                <?php } ?>
            </section>
        <?php } elseif ($block['acf_fc_layout'] == 'quote_box') { ?>
            <section class="content-block content-block__quote-box">
                <div class="row no-gutters">
                    <?php if ($block['image'] != null) { ?>
                        <div class="col-12 col-md-4">
                            <div class="content-block__quote-box__image"
                                 style="background-image: url(<?php echo $block['image']['url']; ?>);">
                            </div>
                        </div>
                    <?php } ?>

                    <div class="col-12 col-md">
                        <div class="content-block__quote-box__content-wrapper">
                            <div class="content-block__quote-box__content">
                                <div class="content-block__quote-box__quote text-block">
                                    <?php echo $block['quote']; ?>
                                </div>
                                <?php if ($block['author'] != '') { ?>
                                    <p class="content-block__quote-box__author">
                                        <?php echo $block['author']; ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php } elseif ($block['acf_fc_layout'] == 'video') {
            $url = $block['url'];
            $video_embed = prepare_video_embed($url);
            if ($url != '' && $video_embed != '') { ?>
                <section class="content-block content-block__video">
                    <div class="video-embed">
                        <?php echo $video_embed; ?>
                    </div>
                </section>
            <?php }
        }
    }
} ?>