<?php
if (is_front_page()) {
    $featured_articles_per_page = 3;
    $featured_projects_per_page = 4;
} else {
    $featured_articles_per_page = 2;
    $featured_projects_per_page = 2;
}
$featured_projects = get_field('option_featured_projects', 'option');
$featured_articles = get_field('option_featured_articles', 'option');

if ($featured_articles == null || empty($featured_articles)) {
    $args = array(
        'numberposts' => $featured_articles_per_page,
        'post_type' => 'post',
        'post_status' => 'publish',

    );

    $featured_articles = get_posts($args);
}
?>

<section class="featured-footer">
    <div class="container">
        <div class="row">
            <?php if ($featured_projects != null) { ?>
                <div class="col-12 col-md-6">
                    <h2 class="small-title small-title--accented">Featured Projects</h2>

                    <div class="featured-footer__items-wrapper">
                        <div class="row small-gutters">
                            <?php
                            $counter = 0;

                            while ($counter <= $featured_projects_per_page - 1) {
                                if (isset($featured_projects[$counter])) {
                                    $featured = $featured_projects[$counter];

                                    if ($counter >= 2) { ?>
                                        <div class="col-12 d-none d-lg-block featured-footer__feature">
                                            <?php include(get_template_directory() . '/inc/partials/feature-card-small.php'); ?>
                                        </div>
                                    <?php } else { ?>
                                        <div class="col-12 col-lg-6 featured-footer__feature">
                                            <?php include(get_template_directory() . '/inc/partials/feature-card.php'); ?>
                                        </div>
                                    <?php }
                                    unset($featured);
                                }
                                $counter++;
                            } ?>
                        </div>
                    </div>

                    <?php if(is_front_page()) { ?>
                        <div class="text-center">
                            <a href="<?php echo get_listing_page_url('project'); ?>" class="arrow-link">
                                See all projects
                                <span class="arrow-link__arrow"><i class="far fa-arrow-right" aria-hidden="true"></i></span>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>

            <div class="col-12 col-md-6">
                <h2 class="small-title small-title--orange small-title--accented">Featured Articles</h2>

                <div class="featured-footer__items-wrapper">
                    <div class="row small-gutters">
                        <?php
                        $counter = 0;

                        while ($counter <= $featured_articles_per_page - 1) {
                            if (isset($featured_articles[$counter])) {
                                $featured = $featured_articles[$counter];
                                if ($counter >= 2) {
                                    $col_width_class = "";
                                    $wide_feature = true;
                                } else {
                                    $col_width_class = "col-lg-6";
                                    $wide_feature = false;
                                }
                                ?>
                                <div class="col-12 featured-footer__feature <?php echo $col_width_class; ?>">
                                    <?php include(get_template_directory() . '/inc/partials/feature-card.php'); ?>
                                </div>
                                <?php unset($featured);
                            }
                            $counter++;
                        } ?>
                    </div>

                    <?php if(is_front_page()) { ?>
                        <div class="text-center">
                            <a href="<?php echo get_news_page_url(); ?>" class="arrow-link">
                                All articles
                                <span class="arrow-link__arrow"><i class="far fa-arrow-right" aria-hidden="true"></i></span>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>