<?php

function paramount_customizer_settings($wp_customize)
{
    /**
     * Site Identity Settings
     */
    // Logo
    $wp_customize->add_setting('company_logo');
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'company_logo',
        array(
            'label' => 'Company Logo',
            'section' => 'title_tagline',
            'settings' => 'company_logo',
        )));
    /**
     * Company Details
     */
    // Add Company Details Section
    $wp_customize->add_section('company_details', array(
        'title' => 'Company Details',
        'description' => '',
        'priority' => 30,
    ));
    // Company Name
    $wp_customize->add_setting('company_name');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'company_name',
        array(
            'label' => 'Company Name',
            'section' => 'company_details',
            'settings' => 'company_name',
            'type' => 'text'
        )));
    // Contact Email
    $wp_customize->add_setting('contact_email');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact_email',
        array(
            'label' => 'Contact Email',
            'section' => 'company_details',
            'settings' => 'contact_email',
            'type' => 'text'
        )));
    // Contact Telephone Number
    $wp_customize->add_setting('contact_telephone');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact_telephone',
        array(
            'label' => 'Contact Telephone Number',
            'section' => 'company_details',
            'settings' => 'contact_telephone',
            'type' => 'text'
        )));
    // Opening Times
    $wp_customize->add_setting('opening_times');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'opening_times',
        array(
            'label' => 'Opening Times',
            'section' => 'company_details',
            'settings' => 'opening_times',
            'type' => 'text'
        )));
    // Company Reg
    $wp_customize->add_setting('company_reg');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'company_reg',
        array(
            'label' => 'Company Reg',
            'section' => 'company_details',
            'settings' => 'company_reg',
            'type' => 'text'
        )));
    // Registered Office
    $wp_customize->add_setting('registered_office');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'registered_office',
        array(
            'label' => 'Registered Office',
            'section' => 'company_details',
            'settings' => 'registered_office',
            'type' => 'text'
        )));
    // Covering Areas
    $wp_customize->add_setting('covering_areas');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'covering_areas',
        array(
            'label' => 'Covering Areas',
            'section' => 'company_details',
            'settings' => 'covering_areas',
            'type' => 'text'
        )));
    /**
     * Navigation Settings
     */
    // Add Site Settings
    $wp_customize->add_section('navigation', array(
        'title' => 'Navigation Settings',
        'description' => '',
        'priority' => 42,
    ));
    $wp_customize->add_setting('services_dropdown_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'services_dropdown_title',
        array(
            'label' => 'Services Dropdown Title',
            'section' => 'navigation',
            'settings' => 'services_dropdown_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting('sectors_dropdown_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'sectors_dropdown_title',
        array(
            'label' => 'Sectors Dropdown Title',
            'section' => 'navigation',
            'settings' => 'sectors_dropdown_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting('projects_dropdown_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'projects_dropdown_title',
        array(
            'label' => 'Projects Dropdown Title',
            'section' => 'navigation',
            'settings' => 'projects_dropdown_title',
            'type' => 'text'
        )));
    /**
     * Contact CTA Settings
     */
    // Add Site Settings
    $wp_customize->add_section('contact_cta', array(
        'title' => 'Contact CTA Settings',
        'description' => '',
        'priority' => 35,
    ));
    $wp_customize->add_setting('contact_cta_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact_cta_title',
        array(
            'label' => 'Title',
            'section' => 'contact_cta',
            'settings' => 'contact_cta_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting( 'contact_cta_button_page_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ));
    $wp_customize->add_control( 'contact_cta_button_page_id', array(
        'type' => 'dropdown-pages',
        'section' => 'contact_cta',
        'label' => __( 'Button Link' )
    ));
    /**
     * Career Page Settings
     */
    // Add Site Settings
    $wp_customize->add_section('career_page', array(
        'title' => 'Career Page Settings',
        'description' => '',
        'priority' => 35,
    ));
    $wp_customize->add_setting('career_form_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'career_form_title',
        array(
            'label' => 'Form Title',
            'section' => 'career_page',
            'settings' => 'career_form_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting('career_form_intro');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'career_form_intro',
        array(
            'label' => 'Form Intro',
            'section' => 'career_page',
            'settings' => 'career_form_intro',
            'type' => 'textarea'
        )));
    $wp_customize->add_setting('career_form_shortcode');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'career_form_shortcode',
        array(
            'label' => 'Form Shortcode',
            'section' => 'career_page',
            'settings' => 'career_form_shortcode',
            'type' => 'text'
        )));
    /**
     * Service Page Settings
     */
    // Add Site Settings
    $wp_customize->add_section('service_page', array(
        'title' => 'Service Page Settings',
        'description' => '',
        'priority' => 36,
    ));
    $wp_customize->add_setting('service_form_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'service_form_title',
        array(
            'label' => 'Form Title',
            'section' => 'service_page',
            'settings' => 'service_form_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting('service_form_intro');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'service_form_intro',
        array(
            'label' => 'Form Intro',
            'section' => 'service_page',
            'settings' => 'service_form_intro',
            'type' => 'textarea'
        )));
    $wp_customize->add_setting('service_form_shortcode');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'service_form_shortcode',
        array(
            'label' => 'Form Shortcode',
            'section' => 'service_page',
            'settings' => 'service_form_shortcode',
            'type' => 'text'
        )));
    /**
     * Project Page Settings
     */
    // Add Site Settings
    $wp_customize->add_section('project_page', array(
        'title' => 'Project Page Settings',
        'description' => '',
        'priority' => 37,
    ));
    $wp_customize->add_setting('project_form_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'project_form_title',
        array(
            'label' => 'Form Title',
            'section' => 'project_page',
            'settings' => 'project_form_title',
            'type' => 'text'
        )));
    $wp_customize->add_setting('project_form_intro');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'project_form_intro',
        array(
            'label' => 'Form Intro',
            'section' => 'project_page',
            'settings' => 'project_form_intro',
            'type' => 'textarea'
        )));
    $wp_customize->add_setting('project_form_shortcode');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'project_form_shortcode',
        array(
            'label' => 'Form Shortcode',
            'section' => 'project_page',
            'settings' => 'project_form_shortcode',
            'type' => 'text'
        )));
    /**
     * Listing Page Settings
     */
    //  Add Site Settings
    $wp_customize->add_section('listing_pages', array(
        'title' => 'Listing Page Settings',
        'description' => 'Define the listing pages for each post type',
        'priority' => 37,
    ));
    $wp_customize->add_setting( 'career_listing_page_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ));
    $wp_customize->add_control( 'career_listing_page_id', array(
        'type' => 'dropdown-pages',
        'section' => 'listing_pages',
        'label' => __( 'Career Listing Page' )
    ));
    $wp_customize->add_setting( 'service_listing_page_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ));
    $wp_customize->add_control( 'service_listing_page_id', array(
        'type' => 'dropdown-pages',
        'section' => 'listing_pages',
        'label' => __( 'Services Listing Page' )
    ));
    $wp_customize->add_setting( 'project_listing_page_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ));
    $wp_customize->add_control( 'project_listing_page_id', array(
        'type' => 'dropdown-pages',
        'section' => 'listing_pages',
        'label' => __( 'Project Listing Page' )
    ));
    $wp_customize->add_setting( 'sector_listing_page_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ));
    $wp_customize->add_control( 'sector_listing_page_id', array(
        'type' => 'dropdown-pages',
        'section' => 'listing_pages',
        'label' => __( 'Sector Listing Page' )
    ));
    /**
     * 404 Page Settings
     */
    // Add Site Settings
    $wp_customize->add_section('four-oh-four', array(
        'title' => '404 Page Settings',
        'description' => '',
        'priority' => 48,
    ));
    // 404 Page Title
    $wp_customize->add_setting('four_oh_four_title');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'four_oh_four_title',
        array(
            'label' => 'Page Title',
            'section' => 'four-oh-four',
            'settings' => 'four_oh_four_title',
            'type' => 'text'
        )));
    // 404 Page Content
    $wp_customize->add_setting('four_oh_four_content');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'four_oh_four_content',
        array(
            'label' => 'Page Content',
            'section' => 'four-oh-four',
            'settings' => 'four_oh_four_content',
            'type' => 'textarea'
        )));
    /**
     * Map Settings
     */
    // Add Site Settings
    $wp_customize->add_section('map_settings', array(
        'title' => 'Map Settings',
        'description' => '',
        'priority' => 50,
    ));
    // Map API key
    $wp_customize->add_setting('map_api_key');
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'map_api_key',
        array(
            'label' => 'Google Maps API Key',
            'section' => 'map_settings',
            'settings' => 'map_api_key',
            'type' => 'text'
        )));

    function themeslug_sanitize_dropdown_pages( $page_id, $setting ) {
        $page_id = absint( $page_id );
        return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
    }
}

add_action('customize_register', 'paramount_customizer_settings');