<?php
$post_type = get_post_type($featured->ID);
$thumb = get_the_post_thumbnail_url($featured->ID);
$wide = false;

if(isset($wide_feature) && $wide_feature == true) {
    $wide = true;
}

?>
<a href="<?php echo get_the_permalink($featured->ID); ?>" class="feature-card <?php echo ($wide ? 'feature-card--wide' : ''); ?>"
   style="background-image: url(<?php echo $thumb; ?>);">
    <div class="feature-card__content h-100 d-flex flex-column">
        <?php if ($post_type == 'post') {
            $datetime1 = new DateTime($featured->post_date);
            $datetime2 = new DateTime(); // current date
            $interval = $datetime1->diff($datetime2);
            if($interval->days > 0) {
                $formatted_interval = $interval->format('%a days ago');
            } else {
                $formatted_interval = 'Today';
            }

            ?>
            <p class="feature-card__date color-white small-title small-title--lowercase">
                <?php echo $formatted_interval; ?>
            </p>
        <?php } ?>

        <h3 class="color-white"><?php echo get_the_title($featured->ID); ?></h3>

        <?php if ($post_type == 'project') {
            $excerpt = get_the_excerpt($featured->ID);
            $services = get_field('related_services', $featured->ID);

            if ($excerpt != '') { ?>
                <div class="feature-card__excerpt text-block">
                    <p><?php echo $excerpt; ?></p>
                </div>
            <?php } ?>

            <?php if($services != null && !empty($services)) {
                $service_titles = array_column($services, 'post_title');
                ?>
                <p class="feature-card__category small-title color-white"><?php echo implode(", ", $service_titles); ?></p>
            <?php } ?>
        <?php } ?>

        <div class="feature-card__btn d-flex flex-grow-1 align-items-end">
            <div class="btn btn-white btn-white--color-primary">
                <?php echo($post_type == 'project' ? 'View project' : 'Read more'); ?>
                <span class="btn__arrow">
                <i class="far fa-arrow-right" aria-hidden="true"></i>
            </span>
            </div>
        </div>
    </div>
</a>