<?php
$thumb = get_the_post_thumbnail_url($service->ID, 'full');
$excerpt = get_the_excerpt($service->ID);
$post_type = get_post_type($service->ID);

?>

<a href="<?php echo get_the_permalink($service->ID); ?>"
   title="<?php echo $service->post_title; ?>"
   class="service-card <?php echo (is_front_page() || is_singular('service') ? 'service-card--blue' : ''); ?>">

    <div class="service-card__image" style="background-image: url(<?php echo ($thumb != '' ? $thumb : '');?>);"></div>

    <div class="service-card__content">
        <h3 class="service-card__title">
            <?php echo $service->post_title; ?>
        </h3>

        <?php if(!is_front_page() && $excerpt != '') { ?>
            <div class="service-card__excerpt text-block">
                <?php echo '<p>' . $excerpt . '</p>'; ?>
            </div>
        <?php } ?>

        <div class="arrow-link service-card__link">
            <?php if($post_type == 'service') {
                echo 'Services & Equipment';
            } else {
                echo 'Read more';
            } ?>
            <span class="arrow-link__arrow"><i class="far fa-arrow-right" aria-hidden="true"></i></span>
        </div>
    </div>
</a>