<?php

get_header();

$masthead_subtitle = get_field('project_masthead_masthead_subtitle');
if ($masthead_subtitle == '') {
    $masthead_subtitle = 'Project';
}

render_masthead('project_masthead', array(
    'show_breadcrumb' => true,
    'masthead_subtitle' => $masthead_subtitle,
    'masthead_size' => 'medium'
));

// Form
$form_title = get_theme_mod('project_form_title');
$form_intro = get_theme_mod('project_form_intro');
$form_shortcode = get_theme_mod('project_form_shortcode');

// Content
$opening_image = get_field('opening_image');
$related_sectors = get_field('related_sectors');
$related_services = get_field('related_services');
$related_articles = get_field('related_articles');

?>

    <section class="project js-contact-form-wrapper">
        <div class="container">
            <div class="row medium-gutters">
                <div class="col-12 col-lg-7">
                    <?php if($opening_image != null) { ?>
                        <div class="project__opening-image">
                            <img src="<?php echo $opening_image['url'];?>"
                                 alt="<?php echo $opening_image['alt'];?>"
                                 class="img-fluid"/>
                        </div>
                    <?php } ?>

                    <div class="page-content-wrapper">
                        <?php render_content_blocks('project_content'); ?>
                    </div>
                </div>

                <div class="col-12 col-lg-5">
                    <?php include(get_template_directory() . '/inc/partials/sidebar-form.php'); ?>
                </div>
            </div>
        </div>
    </section>

<?php if ($related_articles != null || $related_sectors != null || $related_services != null) { ?>
    <section class="project__related">
        <div class="container">
            <div class="row">
                <?php if ($related_services != null) { ?>
                    <div class="col-12 col-md-4">
                        <div class="project__related__section">
                        <h2 class="small-title small-title--accented project__related__title">Related Services</h2>

                        <?php foreach ($related_services as $item) {
                            include(get_template_directory() . '/inc/partials/related-card.php');
                        } ?>
                        </div>
                    </div>
                <?php } ?>

                <?php if ($related_articles != null) { ?>
                    <div class="col-12 col-md-4">
                        <div class="project__related__section">
                        <h2 class="small-title small-title--accented project__related__title">Related Articles</h2>

                        <?php foreach ($related_articles as $item) {
                            include(get_template_directory() . '/inc/partials/related-card.php');
                        } ?>
                    </div>
                    </div>
                <?php } ?>

                <?php if ($related_sectors != null) { ?>
                    <div class="col-12 col-md-4">
                        <div class="project__related__section">
                        <h2 class="small-title small-title--accented project__related__title">Related Sectors</h2>

                        <?php foreach ($related_sectors as $item) {
                            include(get_template_directory() . '/inc/partials/related-card.php');
                        } ?>
                    </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php }

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();