<?php
/* Template Name: Contact */

get_header();

render_masthead('contact_masthead', array(
    'show_breadcrumb' => true
));

// Content
$content = get_field('content');
$email = get_theme_mod('contact_email');
$telephone = get_theme_mod('contact_telephone');
$office_address = get_field('office_address');

// Form
$form_title = get_field('form_title');
$form_intro = get_field('form_introduction');
$form = get_field('form');
if ($form != null) {
    $form_shortcode = '[contact-form-7 id="' . $form->ID . '"]';
}

// Locations
$location_title = get_field('locations_title');
$locations = get_field('locations');

?>

    <section class="contact js-contact-form-wrapper">
        <div class="container">
            <div class="row medium-gutters">
                <div class="col-12 col-lg-7">
                    <div class="page-content-wrapper">
                        <?php if ($content != '') { ?>
                            <div class="text-block contact__content">
                                <?php echo $content; ?>
                            </div>
                        <?php } ?>

                        <?php if ($email != '' || $telephone != '') { ?>
                            <div class="row">
                                <?php if ($telephone != '') { ?>
                                    <div class="col-12 col-md">
                                        <a href="tel:<?php echo $telephone; ?>" class="contact__info-box">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col-auto">
                                                    <div class="contact__info-box__icon">
                                                        <i class="fas fa-phone-alt"></i>
                                                    </div>
                                                </div>

                                                <div class="auto">
                                                    <span><?php echo $telephone; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php } ?>

                                <?php if ($email != '') { ?>
                                    <div class="col-12 col-md">
                                        <a href="mailto:<?php echo $email; ?>" class="contact__info-box">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col-auto">
                                                    <div class="contact__info-box__icon">
                                                        <i class="fas fa-envelope"></i>
                                                    </div>
                                                </div>

                                                <div class="auto">
                                                    <span><?php echo $email; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>

                        <?php if ($office_address != '') { ?>
                            <div class="contact__info-box">
                                <div class="row no-gutters align-items-top">
                                    <div class="col-auto">
                                        <div class="contact__info-box__icon">
                                            <i class="fas fa-map-marker"></i>
                                        </div>
                                    </div>

                                    <div class="auto">
                                        <div class="contact__info-box__address">
                                            <?php echo $office_address; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

                        <?php if ($locations != null) { ?>
                            <section class="contact__map">
                                <?php if ($location_title != '') { ?>
                                    <h2><?php echo $location_title; ?></h2>
                                <?php } ?>

                                <div class="contact__map__inner js-map"
                                     data-locations='<?php echo json_encode($locations);?>'
                                     data-marker="<?php echo get_template_directory_uri() . '/assets/images/map-marker.svg'; ?>"></div>
                            </section>
                        <?php } ?>
                    </div>
                </div>

                <div class="col-12 col-lg-5">
                    <?php include(get_template_directory() . '/inc/partials/sidebar-form.php'); ?>
                </div>
            </div>
        </div>
    </section>

<?php

get_footer();
